<?php
final class AcceptAction extends Action {
    /**
     * @var AcceptDao
     */
    protected $dao = NULL;
    /**
     * @var AcceptDto
     */
    protected $dto = NULL;
    public function __construct() {
    }
    /**
     * @return AcceptDto
     */
    public function getDto() {
        return $this->dto;
    }
    public function index() {
        if (!$mailAddress = $this->dao->checkOneTimeKey($this->dto->getUid())) {
            return new Redirect('errors/show/access');
        }
        if (!$this->dao->checkLimitDateTime($mailAddress)) {
            $this->dao->deletePreRegister($mailAddress);
            return new Redirect('errors/show/limit');
        }
        return new Forward();
    }
}
// EOF.