<?php
/**
 * AppController.
 * @package magic.app
 */
/**
 * フレームワークのコントローラーを読み込みます.
 */
require_once CORE . 'Controller.php';
/**
 * アプリケーションのモジュール読み込みを実行します.
 */
require_once APP . 'Bootstrap.php';
/**
 * アプリケーション側のコントローラーです.
 * @package magic.app
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class AppController extends Controller {
    /**
     * アプリケーション独自の設定ファイルを読み込ませます。
     * <p>
     * ここで設定しなかったクラスについては、
     * フレームワークのデフォルト設定が使用されます。
     * </p>
     * @see Controller::configure()
     */
    protected function configure() {
        // セッション名を設定します。
        $this->session->setName('koshien');
        // 携帯とPCを判別します。
        require_once CORE . 'tool' . DIRECTORY_SEPARATOR . 'mobile' . DIRECTORY_SEPARATOR . 'EasySeparator.php';
        if (EasySeparator::getMobileInfo() === FALSE) {
            require_once APP . 'PcBootstrap.php';
            // PC側PathConfigureの実装クラスを指定します。
            $this->path = new PcPathConfigure();
            // メッセージファイルがあれば設定してください。
            MessageBehavior::setMessageClass($this->path);
        } else {
            require_once APP . 'MobileBootstrap.php';
            // 携帯側PathConfigureの実装クラスを指定します。
            $this->path = new MobilePathConfigure();
            // メッセージファイルがあれば設定してください。
            MessageBehavior::setMessageClass($this->path);
        }
        // DataSourceConfigureの実装クラスを指定します。
        $this->dataSource = new AppDataSourceConfigure();
        // NameConfigureの実装クラスを指定します。
        $this->name = NULL;
        // RouteConfigureの実装クラスを指定します。
        $this->route = NULL;
        // セッションを自動的に開始するかどうかを設定します。
        $this->sessionAutoStart = FALSE;
        // ロケールを固定したい場合のみ設定してください。
        LocaleProvider::setDefaultLocale(NULL);
        // 必要があれば、リクエストのエンコードやサニタイズを実行してください。
    }
    /**
     * システムエラーが発生した場合の処理を拡張します.
     * @see Controller::systemExceptionHandler()
     */
    protected function systemExceptionHandler() {
    }
    /**
     * データベースエラーが発生した場合の処理を拡張します.
     * @see Controller::sqlExceptionHandler()
     */
    protected function sqlExceptionHandler() {
    }
}
// EOF.