<?php
require_once DTO . 'EntryDto.php';
final class EntryConfirm extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new EntryDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    if ($this->dto->self == 'self') {
      $this->dto->contactMode = '応募先へ直接電話で応募する<div style="color: #0000FF;">（応募確認メールにて電話番号をご案内致します）</div>';
      $this->dto->contactDateTime = '';
    } else {
      $this->dto->contactMode = '応募先からの連絡を希望する<div style="color: #0000FF;">（応募確認後、応募先よりご連絡致します）</div>';
      if (empty($this->dto->contactDate)) {
        $this->dto->contactDateTime = '指定なし';
      } else {
        $this->dto->contactDateTime = $this->dto->contactDate . '&nbsp;' . $this->dto->contactTime . '時頃';
      }
    }
    $this->dto->questionList = implode(',&nbsp;', $this->dto->question);
    return new forward();
  }
  public function apply() {
    session_start();
    $_SESSION['DTO'] = $this->dto;
    $_SESSION['DTO'] = serialize($this->dto);
    return new Redirect('entry_apply/apply', SSL);
  }
}
// EOF.
