<?php
require_once DAO . 'OfferDao.php';
require_once DAO . 'OfferOutlineDao.php';
require_once DTO . 'EntryDto.php';
final class EntryApply extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new EntryDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    if ($this->dto->self == 'self') {
      $this->dto->contactMode = '応募先へ直接電話で応募する<div style="color: #0000FF;">（応募確認メールにて電話番号をご案内致します）</div>';
      $this->dto->contactDateTime = '';
    } else {
      $this->dto->contactMode = '応募先からの連絡を希望する<div style="color: #0000FF;">（応募確認後、応募先よりご連絡致します）</div>';
      if (empty($this->dto->contactDate)) {
        $this->dto->contactDateTime = '指定なし';
      } else {
        $this->dto->contactDateTime = $this->dto->contactDate . '&nbsp;' . $this->dto->contactTime . '時頃';
      }
    }
    $this->dto->questionList = implode(',&nbsp;', $this->dto->question);
    session_destroy();
    $_SESSION = array();
    return new Forward();
  }
  public function apply() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    $message = mb_convert_kana($this->dto->familyName, 'KVa') . "様からの求人応募メールです。\n";
    $message .= "■求人番号\n{$this->dto->offerCode}\n";
    $message .= "■店舗名\n{$this->dto->shopName}\n";
    $message .= "■お名前\n" . mb_convert_kana($this->dto->familyName, 'KVa') . " " . mb_convert_kana($this->dto->firstName, 'KVa') . "\n";
    $message .= "■ふりがな\n" . mb_convert_kana($this->dto->familyNameKana, 'KVa') . " " . mb_convert_kana($this->dto->firstNameKana, 'KVa') . "\n";
    $message .= "■メールアドレス\n{$this->dto->email}\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■生年月日\n{$this->dto->birthDate}\n";
    $message .= "■性別\n{$this->dto->sex}\n";
    $message .= "■現在の職業\n{$this->dto->job}\n";
    $message .= "■連絡希望日時\n";
    if ($this->dto->self == 'self') {
      $message .= "応募先に直接電話します\n";
    } elseif (empty($this->dto->contactDate)) {
      $message .= "指定なし\n";
    } else {
      $message .= "{$this->dto->contactDate} {$this->dto->contactTime}時頃\n";
    }
    $message .= "■アンケート\n" . implode(', ', $this->dto->question) . "\n";
    mb_language('Ja');
    mb_internal_encoding('UTF-8');
    mb_send_mail('miura@tns-g.jp', '求人応募メール', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $dao = new OfferDao();
    $result = $dao->getByPk($this->dto->offerCode);
    $row = mysql_fetch_assoc($result);

    $message = "Ｄｅａｒ　ｊｏｂをご利用頂き有難うございます。\n";
    $message .= "以下の内容で応募を受け付けました。\n";
    $message .= "直接応募先へお電話される際は必ず先方へ\n「Ｄｅａｒ　ｊｏｂを見ての応募」とお伝え下さい。\n\n";

    $message .= "■求人番号\n{$this->dto->offerCode}\n\n";

    $message .= "■店舗名\n{$this->dto->shopName}\n";
    if (!empty($row['tanto_name']) && !empty($row['tel_no'])) {
      $message .= "■連絡先担当者名\n{$row['tanto_name']}\n";
      $message .= "■連絡先電話番号\n{$row['tel_no']}\n";
    }
    $dao = new OfferOutlineDao();
    $result = $dao->getByOfferCode($this->dto->offerCode);
    $row = mysql_fetch_assoc($result);
    $message .= "■求人内容\n【{$row['occupation_name']}】{$row['category_name']}\n";
    $message .= DOMAIN . 'job_detail/index/' . $this->dto->offerCode . "\n\n";

    $message .= "■お名前\n" . mb_convert_kana($this->dto->familyName, 'KVa') . " " . mb_convert_kana($this->dto->firstName, 'KVa') . "\n";
    $message .= "■ふりがな\n" . mb_convert_kana($this->dto->familyNameKana, 'KVa') . " " . mb_convert_kana($this->dto->firstNameKana, 'KVa') . "\n";
    $message .= "■メールアドレス\n{$this->dto->email}\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■生年月日\n{$this->dto->birthDate}\n";
    $message .= "■性別\n{$this->dto->sex}\n";
    $message .= "■現在の職業\n{$this->dto->job}\n\n";

    $message .= "■連絡希望日時\n";
    if ($this->dto->self == 'self') {
      $message .= "応募先に直接電話します\n";
    } elseif (empty($this->dto->contactDate)) {
      $message .= "指定なし\n";
    } else {
      $message .= "{$this->dto->contactDate} {$this->dto->contactTime}時頃\n";
    }
    $message .= "■アンケート\n" . implode(', ', $this->dto->question) . "\n";
    $message .= "------------------------\n";
    $message .= "このメールは、ご応募頂いたメールを受信した事の確認のため、自動返信させて頂いています。\n";
    $message .= "------------------------\n";
    $message .= "Dear job（株式会社テクニカルシステムサポート）\n";
    $message .= "TEL：075-864-0104\n";
    mb_send_mail($this->dto->email, '求人応募の受付', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $_SESSION['DTO'] = serialize($this->dto);
    return new Redirect('entry_apply', SSL);
  }
}
// EOF.
