<?php
final class OfferTimeDao extends Dao {
  private static $ALL = <<<'SQL'
select offer_code,
       search_time
  from offer_time
 order by offer_code,
       search_time
SQL;
  private static $PK = <<<'SQL'
select offer_code,
       search_time
  from offer_time
 where offer_code = '%s'
   and search_time = %s
SQL;
  private static $OFFER_CODE = <<<'SQL'
select offer_code,
       search_time
  from offer_time
 where offer_code = '%s'
 order by search_time
SQL;
  private static $DELETE = <<<'SQL'
delete from offer_time
 where offer_code = '%s'
SQL;
  private static $INSERT = <<<'SQL'
replace into offer_time
             (offer_code,
              search_time)
      values ('%s',
              %s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function getByOfferCode($offerCode) {
    return $this->execute(self::$OFFER_CODE, $offerCode);
  }
  public function delete($offerCode) {
    return $this->execute(self::$DELETE, $offerCode);
  }
  public function insert($offerCode, $searchTime) {
    return $this->execute(self::$INSERT, array($offerCode, $searchTime));
  }
}
// EOF.
