<?php
final class OfferConditionDao extends Dao {
  private static $ALL = <<<'SQL'
select offer_code,
       condition_id
  from offer_condition
 order by offer_code,
       condition_id
SQL;
  private static $PK = <<<'SQL'
select offer_code,
       condition_id
  from offer_condition
 where offer_code = '%s'
   and condition_id = %s
SQL;
  private static $OFFER_CODE = <<<'SQL'
select oc.offer_code,
       oc.condition_id,
       (select co.condition_name
          from `condition` co
         where co.condition_id = oc.condition_id) as condition_name
  from offer_condition oc
 where oc.offer_code = '%s'
 order by oc.condition_id
SQL;
  private static $DELETE = <<<'SQL'
delete from offer_condition
 where offer_code = '%s'
SQL;
  private static $INSERT = <<<'SQL'
insert into offer_condition
            (offer_code,
             condition_id)
     values ('%s',
             %s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function getByOfferCode($offerCode) {
    return $this->execute(self::$OFFER_CODE, $offerCode);
  }
  public function delete($offerCode) {
    return $this->execute(self::$DELETE, $offerCode);
  }
  public function insert($offerCode, $conditionId) {
    return $this->execute(self::$INSERT, array($offerCode, $conditionId));
  }
}
// EOF.
