<?php
final class ConditionDao extends Dao {
  private static $ALL = <<<'SQL'
select condition_id,
       condition_name
  from `condition`
 order by condition_id
SQL;
  private static $PK = <<<'SQL'
select condition_id,
       condition_name
  from `condition`
 where condition_id = %s
SQL;
  private static $UPDATE = <<<'SQL'
update `condition`
   set condition_name ='%s'
 where condition_id = %s
SQL;
  private static $INSERT = <<<'SQL'
insert into `condition`
            (condition_id,
             condition_name)
     values (null,
             '%s')
SQL;
  private static $LAST_INSERT_ID = <<<'SQL'
select LAST_INSERT_ID()
SQL;
  private static $DELETE = <<<'SQL'
delete from `condition`
 where condition_id = %s
SQL;
  private static $DELETE_OFFER = <<<'SQL'
delete from offer_condition
 where condition_id = %s
SQL;
  private static $NAME_LIST = <<<'SQL'
select condition_name
  from `condition`
 where condition_id in (%s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function update($name, $conditionId) {
    $this->execute(self::$UPDATE, array($name, $conditionId));
  }
  public function insert($conditionName) {
    $this->execute(self::$INSERT, $conditionName);
    return mysql_result($this->execute(self::$LAST_INSERT_ID), 0);
  }
  public function delete($conditionId) {
    $this->execute(self::$DELETE, $conditionId);
    $this->execute(self::$DELETE_OFFER, $conditionId);
  }
  public function getNameList($conditionId) {
    return $this->execute(self::$NAME_LIST, $conditionId);
  }
}
// EOF.
