<?php
final class CompensationDao extends Dao {
  private static $ALL = <<<'SQL'
select compensation_id,
       compensation_name
  from compensation
 order by compensation_id
SQL;
  private static $PK = <<<'SQL'
select compensation_id,
       compensation_name
  from compensation
 where compensation_id = %s
SQL;
  private static $UPDATE = <<<'SQL'
update compensation
   set compensation_name = '%s'
 where compensation_id = %s
SQL;
  private static $INSERT = <<<'SQL'
insert into compensation
            (compensation_id,
             compensation_name)
     values (null,
             '%s')
SQL;
  private static $LAST_INSERT_ID = <<<'SQL'
select LAST_INSERT_ID()
SQL;
  private static $DELETE = <<<'SQL'
delete from compensation
 where compensation_id = %s
SQL;
  private static $DELETE_OFFER = <<<'SQL'
delete from offer_compensation
 where compensation_id = %s
SQL;
  private static $NAME_LIST = <<<'SQL'
select compensation_name
  from compensation
 where compensation_id in (%s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function update($name, $compensationId) {
    $this->execute(self::$UPDATE, array($name, $compensationId));
  }
  public function insert($compensationName) {
    $this->execute(self::$INSERT, $compensationName);
    return mysql_result($this->execute(self::$LAST_INSERT_ID), 0);
  }
  public function delete($compensationId) {
    $this->execute(self::$DELETE, $compensationId);
    $this->execute(self::$DELETE_OFFER, $compensationId);
  }
  public function getNameList($compensationId) {
    return $this->execute(self::$NAME_LIST, $compensationId);
  }
}
// EOF.
