<?php
final class CategoryDao extends Dao {
  private static $ALL = <<<'SQL'
select occupation_id,
       category_id,
       category_name
  from category
 order by category_id
SQL;
  private static $PK = <<<'SQL'
select occupation_id,
       category_id,
       category_name
  from category
 where occupation_id = %s
   and category_id = %s
SQL;
  private static $UPDATE = <<<'SQL'
update category
   set category_name = '%s'
 where occupation_id = %s
   and category_id = %s
SQL;
  private static $OCCUPATION_ID = <<<'SQL'
select occupation_id,
       category_id,
       category_name
  from category
 where occupation_id = %s
 order by category_id
SQL;
  private static $INSERT = <<<'SQL'
insert into category
            (occupation_id,
             category_id,
             category_name)
     values (%s,
             %s,
             '%s')
SQL;
  private static $MAX = <<<'SQL'
select ifnull(max(category_id) + 1, 1)
  from category
 where occupation_id = %s
SQL;
  private static $DELETE = <<<'SQL'
delete from category
 where occupation_id = %s
   and category_id = %s
SQL;
  private static $DELETE_CONTENT = <<<'SQL'
delete from content
 where occupation_id = %s
   and category_id = %s
SQL;
  private static $DELETE_OFFER = <<<'SQL'
delete from offer_outline
 where occupation_id = %s
   and category_id = %s
SQL;

  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function update($name, $occupationId, $categoryId) {
    $this->execute(self::$UPDATE, array($name, $occupationId, $categoryId));
  }
  public function getByOccupationId($key) {
    return $this->execute(self::$OCCUPATION_ID, $key);
  }
  public function insert($occupationId, $categoryName) {
    $max = mysql_result($this->execute(self::$MAX, $occupationId), 0);
    $this->execute(self::$INSERT, array($occupationId, $max, $categoryName));
    return $max;
  }
  public function delete(array $param) {
    $this->execute(self::$DELETE, $param);
    $this->execute(self::$DELETE_CONTENT, $param);
    $this->execute(self::$DELETE_OFFER, $param);
  }
}
// EOF.
