<?php
require_once DAO . 'OccupationDao.php';
require_once DAO . 'CategoryDao.php';
require_once DAO . 'ContentDao.php';
require_once DTO . 'OutlineDto.php';
require_once INTERNAL . 'NoCache.php';
final class Outline extends Action {
  private $dto;
  public function __construct() {
    $this->checkAccess();
    $this->dto = new OutlineDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    $dao = new OccupationDao();
    $occupations = $dao->getAll();
    while ($row = mysql_fetch_assoc($occupations)) {
      $this->dto->occupation[] = array('name' => $row['occupation_name'], 'value' => $row['occupation_id']);
    }
    return new Forward();
  }
  public function category() {
    header('Content-Type: application/json; charset=utf-8');
    $dao = new CategoryDao();
    $res = $dao->getByOccupationId($this->dto->occupationId);
    $result = array();
    while ($row = mysql_fetch_assoc($res)) {
      $result[] = '"' . $row['category_id'] . '":"' . $row['category_name'] . '"';
    }
    echo '{' . implode(',', $result) . '}';
    return new Direct();
  }
  public function content() {
    header('Content-Type: application/json; charset=utf-8');
    $dao = new ContentDao();
    $res = $dao->getByOccupationCategoryId(array($this->dto->occupationId, $this->dto->categoryId));
    $result = array();
    while ($row = mysql_fetch_assoc($res)) {
      $result[] = '"' . $row['content_id'] . '":"' . $row['content_name'] . '"';
    }
    echo '{' . implode(',', $result) . '}';
    return new Direct();
  }
  public function add() {
    header('Content-Type: application/json; charset=utf-8');
    $dao;
    $no = 0;
    switch ($this->dto->option) {
      case 'occupation':
        $dao = new OccupationDao();
        $no = $dao->insert($this->dto->name);
        break;
      case 'category':
        $dao = new CategoryDao();
        $no = $dao->insert($this->dto->occupationId, $this->dto->name);
        break;
      case 'content':
        $dao = new ContentDao();
        $no = $dao->insert($this->dto->occupationId, $this->dto->categoryId, $this->dto->name);
    }
    echo '{"' . $no . '":"' . $this->dto->name . '"}';
    return new Direct();
  }
  public function edit() {
    header('Content-Type: application/json; charset=utf-8');
    $dao;
    switch ($this->dto->option) {
      case 'occupation':
        $dao = new OccupationDao();
        $dao->update($this->dto->name, $this->dto->occupationId);
        break;
      case 'category':
        $dao = new CategoryDao();
        $dao->update($this->dto->name, $this->dto->occupationId, $this->dto->categoryId);
        break;
      case 'content':
        $dao = new ContentDao();
        $dao->update($this->dto->name, $this->dto->occupationId, $this->dto->categoryId, $this->dto->contentId);
    }
    echo '{"result":"OK"}';
    return new Direct();
  }
  public function del() {
    header('Content-Type: application/json; charset=utf-8');
    $dao;
    switch ($this->dto->option) {
      case 'occupation':
        $dao = new OccupationDao();
        $dao->delete($this->dto->occupationId);
        break;
      case 'category':
        $dao = new CategoryDao();
        $dao->delete(array($this->dto->occupationId, $this->dto->categoryId));
        break;
      case 'content':
        $dao = new ContentDao();
        $dao->delete(array($this->dto->occupationId, $this->dto->categoryId, $this->dto->contentId));
    }
    echo '{"result":"OK"}';
    return new Direct();
  }
}
// EOF.
