<?php
require_once DAO . 'PrefectureDao.php';
require_once DAO . 'CityDao.php';
require_once DAO . 'WardDao.php';
require_once DAO . 'OfferDao.php';
require_once DTO . 'OfferListDto.php';
require_once INTERNAL . 'NoCache.php';
final class OfferList extends Action {
  private $dto;
  public function __construct() {
    $this->checkAccess();
    $this->dto = new OfferListDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    $dao = new PrefectureDao();
    $this->dto->prefecture = Generator::getOptionsByResource($dao->getAll(), 'prefecture_id', 'prefecture_name');
    return new Forward();
  }
  public function search() {
    $_SESSION['SEARCH'] = serialize($this->dto);
    $dao = new OfferDao();
    $this->dto->offerList = $dao->getOfferList($this->dto->offerCode, $this->dto->shopName, $this->dto->prefectureId, $this->dto->cityId, $this->dto->wardId, $this->dto->address, $this->dto->status);
    $this->dto->count = mysql_num_rows($this->dto->offerList);
    $dao = new PrefectureDao();
    $this->dto->prefecture = Generator::getOptionsByResource($dao->getAll(), 'prefecture_id', 'prefecture_name', $this->dto->prefectureId);
    $dao = new CityDao();
    $this->dto->city = Generator::getOptionsByResource($dao->getAll(), 'city_id', 'city_name', $this->dto->cityId);
    $dao = new WardDao();
    $this->dto->ward = Generator::getOptionsByResource($dao->getAll(), 'ward_id', 'ward_name', $this->dto->wardId);
    return new forward();
  }
  public function back() {
    if (isset($_SESSION['SEARCH'])) {
      $this->dto = unserialize($_SESSION['SEARCH']);
    }
    return $this->search();
  }
  public function delete() {
    $dao = new OfferDao();
    $dao->delete($this->dto->option);
    return $this->search();
  }
}
// EOF.
