<?php
require_once DAO . 'PrefectureDao.php';
require_once DAO . 'CityDao.php';
require_once DAO . 'WardDao.php';
require_once DAO . 'OccupationDao.php';
require_once DAO . 'ConditionDao.php';
require_once DAO . 'CompensationDao.php';
require_once DAO . 'OfferOutlineDao.php';
require_once DAO . 'OfferTimeDao.php';
require_once DAO . 'OfferHoursDao.php';
require_once DAO . 'OfferConditionDao.php';
require_once DAO . 'OfferCompensationDao.php';
require_once DAO . 'OfferSalaryDao.php';
require_once DAO . 'OfferRemarkDao.php';
require_once DAO . 'OfferCodeDao.php';
require_once DAO . 'OfferDao.php';
require_once DTO . 'OfferDto.php';
require_once INTERNAL . 'NoCache.php';
final class Offer extends Action {
  private $dto;
  public function __construct() {
    $this->checkAccess();
    $this->dto = new OfferDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    $this->dto->newFlag = '1';
    $dao = new PrefectureDao();
    $this->dto->prefecture = Generator::getOptionsByResource($dao->getAll(), 'prefecture_id', 'prefecture_name');
    $this->createSelect();
    return new forward();
  }
  public function edit() {
    $this->dto->offerCode = $this->dto->option;
    $dao = new OfferDao();
    $offer = mysql_fetch_assoc($dao->getByPk($this->dto->offerCode));
    $this->dto->shopName = $offer['shop_name'];
    $this->dto->area = $offer['prefecture_name'] . $offer['city_name'] . $offer['ward_name'];
    $this->dto->address = $offer['address'];
    $this->dto->tantoName = $offer['tanto_name'];
    $this->dto->telNo = $offer['tel_no'];
    $this->dto->lat = $offer['lat'];
    $this->dto->lng = $offer['lng'];
    $this->dto->access = $offer['access'];
    $this->dto->title = $offer['title'];
    $this->dto->message = $offer['message'];
    $this->dto->celebrate = $offer['celebrate'];
    $this->dto->newFlag = $offer['new_flag'];
    $this->dto->currPhoto1 = $offer['photo_1'];
    $this->dto->currPhoto2 = $offer['photo_2'];
    $this->dto->delFlag = $offer['del_flag'];
    $this->dto->mode = $offer['break_flag'];
    $this->createSelect();
    $dao = new OfferOutlineDao();
    $outlines = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($outlines)) {
      $this->dto->outline[] = array('name' => $row['occupation_name'] . '/' . $row['category_name'] . '/' . $row['content_name'], 'value' => $row['occupation_id'] . ',' . $row['category_id'] . ',' . $row['content_id']);
    }
    $dao = new OfferTimeDao();
    $times = $dao->getByOfferCode($this->dto->offerCode);
    $temp = array();
    while ($row = mysql_fetch_assoc($times)) {
      $temp[] = $row['search_time'];
    }
    $this->dto->searchTimeList = '["' . implode('","', $temp) . '"]';
    $dao = new OfferHoursDao();
    $hours = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($hours)) {
      $this->dto->time[] = array('name' => $row['start_time'] . '：' . $row['start_min'] . '～' . $row['end_time'] . '：' . $row['end_min'], 'value' => $row['start_time'] . ',' . $row['start_min'] . ',' . $row['end_time'] . ',' . $row['end_min']);
    }
    $dao = new OfferConditionDao();
    $conditions = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($conditions)) {
      $this->dto->condition[] = array('name' => $row['condition_name'], 'value' => $row['condition_id']);
    }
    $dao = new OfferCompensationDao();
    $compensation = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($compensation)) {
      $this->dto->compensation[] = array('name' => $row['compensation_name'], 'value' => $row['compensation_id']);
    }
    $dao = new OfferSalaryDao();
    $salary = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($salary)) {
      $this->dto->salary[] = $row['salary'];
    }
    $dao = new OfferRemarkDao();
    $remark = $dao->getByOfferCode($this->dto->offerCode);
    while ($row = mysql_fetch_assoc($remark)) {
      $this->dto->remark[] = $row['remark'];
    }
    $this->dto->editMode = '1';
    return new forward();
  }
  public function register() {
    $dao = new OfferCodeDao();
    $this->dto->offerCode = $dao->getNextVal($this->dto->prefectureId, $this->dto->cityId, $this->dto->wardId);
    list($photo1, $photo2) = $this->createImages();
    $values = array();
    $values[] = $this->dto->offerCode;
    $values[] = $this->dto->shopName;
    $values[] = $this->dto->prefectureId;
    $values[] = $this->dto->cityId;
    $values[] = $this->dto->wardId;
    $values[] = $this->dto->address;
    $values[] = $this->dto->tantoName;
    $values[] = $this->dto->telNo;
    $values[] = $this->nvl($this->dto->lat);
    $values[] = $this->nvl($this->dto->lng);
    $values[] = $this->dto->access;
    $values[] = $this->dto->newFlag;
    $values[] = $this->nvl($this->dto->celebrate);
    $values[] = $this->dto->title;
    $values[] = $this->dto->message;
    $values[] = $photo1;
    $values[] = $photo2;
    $values[] = $this->dto->mode;
    $dao = new OfferDao();
    $dao->insert($values);
    $this->deleteInsert();
    if ($this->dto->mode == '0') {
      return new Redirect('back/complete/index/register');
    } else {
      return new Redirect('back/complete/index/temp_register');
    }
  }
  public function modify() {
    list($photo1, $photo2) = $this->createImages();
    $values = array();
    $values[] = $this->dto->shopName;
    $values[] = $this->dto->address;
    $values[] = $this->dto->tantoName;
    $values[] = $this->dto->telNo;
    $values[] = $this->nvl($this->dto->lat);
    $values[] = $this->nvl($this->dto->lng);
    $values[] = $this->dto->access;
    $values[] = $this->dto->newFlag;
    $values[] = $this->nvl($this->dto->celebrate);
    $values[] = $this->dto->title;
    $values[] = $this->dto->message;
    $values[] = $photo1;
    $values[] = $photo2;
    $values[] = $this->dto->mode;
    $values[] = $this->dto->offerCode;
    $dao = new OfferDao();
    $dao->update($values);
    $this->deleteInsert();
    if ($this->dto->mode == '0') {
      return new Redirect('back/complete/index/modify');
    } else {
      return new Redirect('back/complete/index/temp_modify');
    }
  }
  private function createImages() {
    $photo1 = '';
    $photo2 = '';
    if (is_file(IMAGES . $this->dto->currPhoto1)) {
      $photo1 = $this->dto->offerCode . '_1.' . pathinfo($this->dto->currPhoto1, PATHINFO_EXTENSION);
    }
    if (is_file(IMAGES . $this->dto->currPhoto2)) {
      $photo2 = $this->dto->offerCode . '_2.' . pathinfo($this->dto->currPhoto2, PATHINFO_EXTENSION);
    }
    if (!empty($photo1)) {
      rename(IMAGES . $this->dto->currPhoto1, IMAGES . $photo1);
    }
    if (!empty($photo2)) {
      if ($this->dto->currPhoto1 == $this->dto->currPhoto2) {
        copy(IMAGES . $photo1, IMAGES . $photo2);
      } else {
        rename(IMAGES . $this->dto->currPhoto2, IMAGES . $photo2);
      }
    }
    return array($photo1, $photo2);
  }
  private static $TIMES = array('深夜 0' => '深夜 0', '深夜 1' => '深夜 1', '深夜 2' => '深夜 2', '深夜 3' => '深夜 3', '早朝 4' => '早朝 4', '早朝 5' => '早朝 5', '早朝 6' => '早朝 6', '7' => '7', '8' => '8', '9' => '9', '10' => '10', '11' => '11', '12' => '12', '13' => '13', '14' => '14', '15' => '15', '16' => '16', '17' => '17', '18' => '18', '19' => '19', '20' => '20', '21' => '21', '22' => '22', '23' => '23');
  private static $MINUTES = array('00' => '00', '15' => '15', '30' => '30', '45' => '45');
  private function createSelect() {
    $dao = new OccupationDao();
    $this->dto->occupation = Generator::getOptionsByResource($dao->getAll(), 'occupation_id', 'occupation_name');
    $dao = new ConditionDao();
    $this->dto->conditionList = Generator::getOptionsByResource($dao->getAll(), 'condition_id', 'condition_name');
    $dao = new CompensationDao();
    $this->dto->compensationList = Generator::getOptionsByResource($dao->getAll(), 'compensation_id', 'compensation_name');
    $this->dto->times = Generator::getOptionsByArray(self::$TIMES);
    $this->dto->minutes = Generator::getOptionsByArray(self::$MINUTES);
  }
  private function deleteInsert() {
    $dao = new OfferOutlineDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->outline as $val) {
      if (empty($val)) {
        continue;
      }
      list($occupationId, $categoryId, $contentId) = explode(',', $val);
      $dao->insert($this->dto->offerCode, $occupationId, $categoryId, $contentId);
    }
    $dao = new OfferTimeDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->searchTime as $val) {
      $dao->insert($this->dto->offerCode, $val);
    }
    $dao = new OfferHoursDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->time as $val) {
      if (empty($val)) {
        continue;
      }
      list($startTime, $startMin, $endTime, $endMin) = explode(',', $val);
      $dao->insert($this->dto->offerCode, $startTime, $startMin, $endTime, $endMin);
    }
    $dao = new OfferConditionDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->condition as $val) {
      if (empty($val)) {
        continue;
      }
      $dao->insert($this->dto->offerCode, $val);
    }
    $dao = new OfferCompensationDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->compensation as $val) {
      if (empty($val)) {
        continue;
      }
      $dao->insert($this->dto->offerCode, $val);
    }
    $dao = new OfferSalaryDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->salary as $val) {
      if (empty($val)) {
        continue;
      }
      $dao->insert($this->dto->offerCode, $val);
    }
    $dao = new OfferRemarkDao();
    $dao->delete($this->dto->offerCode);
    foreach ($this->dto->remark as $val) {
      if (empty($val)) {
        continue;
      }
      $dao->insert($this->dto->offerCode, $val);
    }
  }
  public function restore() {
    header('Content-Type: application/json; charset=utf-8');
    $dao = new OfferDao();
    $dao->restore($this->dto->offerCode);
    echo '{"result":"OK"}';
    return new Direct();
  }
  private function nvl($value) {
    return empty($value) ? 'null' : $value;
  }
}
// EOF.
