package batch.controller;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * バッチ管理
 *
 * @author Tadashi Nakayama
 */
public interface JobManager extends Remote {

	/** バッチ管理バインド名 */
	String BATCH_BIND_NAME = "/JobManager";

	/**
	 * バッチジョブ処理中止メソッド
	 *
	 * @param jobseq ジョブ連番
	 * @throws RemoteException リモート例外
	 */
	void cancel(long jobseq) throws RemoteException;
}
