package batch.status;

import java.sql.Connection;
import java.util.List;

import core.util.bean.Pair;

/**
 * ジョブファイル管理テーブル取得／更新
 *
 * @author Tadashi Nakayama
 */
public interface JobFileStatus {

	/**
	 * ファイル管理レコード取得
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @param dseq ジョブ詳細連番
	 * @param fseq ファイル連番
	 * @return レコード情報
	 */
	JobFile getJobFile(Connection conn, long jseq, int dseq, int fseq);

	/**
	 * ファイル管理レコード取得
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @param dseq ジョブ詳細連番
	 * @param fseq ファイル連番
	 * @return レコード情報
	 */
	JobFile getJobFileWithLock(Connection conn, long jseq, int dseq, int fseq);

	/**
	 * ファイル管理レコードリスト取得
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @return レコードリスト
	 */
	List<JobFile> selectJobFiles(Connection conn, long jseq);

	/**
	 * ファイル管理レコード更新
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @param dseq ジョブ詳細連番
	 * @param fseq ファイル連番
	 * @param count ダウンロード回数
	 * @param size ファイルサイズ
	 * @return 更新件数
	 */
	int updateJobFile(Connection conn, long jseq, int dseq, int fseq, int count, long size);

	/**
	 * ファイル管理削除
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @return 削除件数
	 */
	int deleteJobFile(Connection conn, long jseq);

	/**
	 * ファイル管理レコード新規作成
	 *
	 * @param conn コネクション
	 * @param jfile ジョブファイル
	 * @return 作成件数
	 */
	int insertJobFile(Connection conn, JobFile jfile);

	/**
	 * バッチ生成ファイル追加
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @param dtlno バッチ連番
	 * @param list 作成ファイルリスト
	 * @return 作成レコード数
	 */
	int setFiles(Connection conn, long jseq, int dtlno, List<Pair<String, String>> list);

	/**
	 * ファイル削除
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @return 処理結果数
	 */
	int deleteFiles(Connection conn, long jseq);

	/**
	 * ファイル管理テーブルダウンロード回数更新
	 *
	 * @param conn コネクション
	 * @param jseq ジョブ連番
	 * @param dseq ジョブ詳細連番
	 * @param fseq ファイル連番
	 * @return 取得項目値
	 */
	JobFile countUpDownload(Connection conn, long jseq, int dseq, int fseq);
}
