CREATE TABLE MS_CODE
(
    ID                          BIGINT       PRIMARY KEY,
    SB_CODE                     VARCHAR(64)  NOT NULL,
    NM_SB_CODE                  VARCHAR(128) NOT NULL,
    CODE                        VARCHAR(128) NOT NULL,
    NM_CODE                     VARCHAR(256) NOT NULL,
    NM_CODE_RYAKU               VARCHAR(256),
    NM_CODE_OPTION              VARCHAR(256) NOT NULL,
    NO_ORDER                    INTEGER      NOT NULL,
    TX_COMMENT                  VARCHAR(512),
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR(32)  NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR(32)  NOT NULL,
    VERSION                     INTEGER      NOT NULL DEFAULT 1,
    CONSTRAINT MS_CODE_UIX01 UNIQUE (SB_CODE, CODE)
)
;

COMMENT ON TABLE MS_CODE IS 'コードマスタ';
COMMENT ON COLUMN MS_CODE.ID IS 'キー';
COMMENT ON COLUMN MS_CODE.SB_CODE IS 'コード種別';
COMMENT ON COLUMN MS_CODE.NM_SB_CODE IS 'コード種別名';
COMMENT ON COLUMN MS_CODE.CODE IS 'コード';
COMMENT ON COLUMN MS_CODE.NM_CODE IS 'コード名';
COMMENT ON COLUMN MS_CODE.NM_CODE_RYAKU IS 'コード名略称';
COMMENT ON COLUMN MS_CODE.NM_CODE_OPTION IS 'コード選択表示名';
COMMENT ON COLUMN MS_CODE.NO_ORDER IS '表示順序';
COMMENT ON COLUMN MS_CODE.TX_COMMENT IS 'コメント';
COMMENT ON COLUMN MS_CODE.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN MS_CODE.INSERT_ID IS '作成ID';
COMMENT ON COLUMN MS_CODE.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN MS_CODE.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN MS_CODE.VERSION IS 'バージョン';
