/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.hibernate.tool.Version;
import org.hibernate.tool.hbm2x.ExporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateHelper {
    static final Logger log = LoggerFactory.getLogger(TemplateHelper.class);
    private String templatePrefix;
    private File outputDirectory;
    protected Configuration freeMarkerEngine;
    protected SimpleHash context;

    public void init(File outputDirectory, String[] templatePaths) {
        this.outputDirectory = outputDirectory;
        this.context = new SimpleHash(ObjectWrapper.BEANS_WRAPPER);
        this.freeMarkerEngine = new Configuration();
        ArrayList<Object> loaders = new ArrayList<Object>();
        for (int i = 0; i < templatePaths.length; ++i) {
            File file = new File(templatePaths[i]);
            if (file.exists() && file.isDirectory()) {
                try {
                    loaders.add(new FileTemplateLoader(file));
                    continue;
                }
                catch (IOException e) {
                    throw new ExporterException("Problems with templatepath " + file, e);
                }
            }
            log.warn("template path" + file + " either does not exist or is not a directory");
        }
        loaders.add(new ClassTemplateLoader(this.getClass(), "/"));
        this.freeMarkerEngine.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()])));
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void putInContext(String key, Object value) {
        log.trace("putInContext " + key + "=" + value);
        if (value == null) {
            throw new IllegalStateException("value must not be null for " + key);
        }
        Object replaced = this.internalPutInContext(key, value);
        if (replaced != null) {
            log.warn("Overwriting " + replaced + " when setting " + key + " to " + value + ".");
        }
    }

    public void removeFromContext(String key, Object expected) {
        log.trace("removeFromContext " + key + "=" + expected);
        Object replaced = this.internalRemoveFromContext(key);
        if (replaced == null) {
            throw new IllegalStateException(key + " did not exist in template context.");
        }
    }

    public void ensureExistence(File destination) {
        File dir = destination.getAbsoluteFile().getParentFile();
        if (dir.exists() && !dir.isDirectory()) {
            throw new ExporterException("The path: " + dir.getAbsolutePath() + " exists, but is not a directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            if (dir.getName().equals(".") && dir.getParentFile().mkdirs()) {
                return;
            }
            throw new ExporterException("unable to create directory: " + dir.getAbsolutePath());
        }
    }

    protected String getTemplatePrefix() {
        return this.templatePrefix;
    }

    protected SimpleHash getContext() {
        return this.context;
    }

    public void processString(String template, Writer output) {
        try {
            StringReader r = new StringReader(template);
            Template t = new Template("unknown", (Reader)r, this.freeMarkerEngine);
            t.process((Object)this.getContext(), output);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (TemplateException te) {
            throw new ExporterException("Error while processing template string", te);
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template string", e);
        }
    }

    public void setupContext() {
        this.getContext().put("version", (Object)Version.getDefault());
        this.getContext().put("ctx", (Object)this.getContext());
        this.getContext().put("templates", (Object)new Templates());
        this.getContext().put("date", (Object)new SimpleDate(new Date(), 3));
    }

    protected Object internalPutInContext(String key, Object value) {
        TemplateModel model = null;
        try {
            model = this.getContext().get(key);
        }
        catch (TemplateModelException e) {
            throw new ExporterException("Could not get key " + key, e);
        }
        this.getContext().put(key, value);
        return model;
    }

    protected Object internalRemoveFromContext(String key) {
        TemplateModel model = null;
        try {
            model = this.getContext().get(key);
        }
        catch (TemplateModelException e) {
            throw new ExporterException("Could not get key " + key, e);
        }
        this.getContext().remove(key);
        return model;
    }

    public void processTemplate(String templateName, Writer output, String rootContext) {
        if (rootContext == null) {
            rootContext = "Unknown context";
        }
        try {
            Template template = this.freeMarkerEngine.getTemplate(templateName);
            template.process((Object)this.getContext(), output);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing " + rootContext + " with template " + templateName, e);
        }
        catch (TemplateException te) {
            throw new ExporterException("Error while processing " + rootContext + " with template " + templateName, te);
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing " + rootContext + " with template " + templateName, e);
        }
    }

    public boolean templateExists(String templateName) {
        TemplateLoader templateLoader = this.freeMarkerEngine.getTemplateLoader();
        try {
            return templateLoader.findTemplateSource(templateName) != null;
        }
        catch (IOException e) {
            throw new ExporterException("templateExists for " + templateName + " failed", e);
        }
    }

    public class Templates {
        public void createFile(String content, String fileName) {
            Writer fw = null;
            try {
                fw = new BufferedWriter(new FileWriter(new File(TemplateHelper.this.getOutputDirectory(), fileName)));
                fw.write(content);
            }
            catch (IOException io) {
                throw new ExporterException("Problem when writing to " + fileName, io);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.flush();
                        fw.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
    }
}

