﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace loxXmlUtils
{
    public class TJxSolItemBase
    {
        public class TJxCsvData
        {
            public string Category1 { get; set; }
            public string Category2 { get; set; }
            public string Category3 { get; set; }
            public string Text { get; set; }
        }

        protected string FCategory = null;
        public string Category { get { return this.FCategory; } }

//        private string FSpeaker = null;
//        public string Speaker { get { return this.FSpeaker; } set { this.FSpeaker = value; } }

        private List<string> FItemDetailList = new List<string>();
        public List<string> ItemDetailList { get { return this.FItemDetailList; } }

        public TJxSolItemBase(string Category)
        {
            this.FCategory = Category;
        }

        public void addValue(string value)
        {
            this.FItemDetailList.Add(value);
        }

        public override string ToString()
        {
            return base.ToString();
        }

        public virtual Dictionary<string, string> ToDictionary()
        {
            return null;
        }

        protected TJxCsvData makeCsvData(string Category1, string Category2, string Category3, string Text)
        {
            TJxCsvData data = new TJxCsvData();
            data.Category1 = Category1;
            data.Category2 = Category2;
            data.Category3 = Category3;
            data.Text = Text;
            return data;
        }

        public virtual List<TJxCsvData> ToCsv()
        {
            return null;
        }

        public virtual bool checkID(int no)
        {
            return false;
        }
    }

}
