﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace loxXmlUtils
{
    public class TJxSolItemUtils
    {
        public static TJxSolItemBase makeJxSolItem(string Category)
        {
            TJxSolItemBase obj = null;
            switch (Category) {
                case "Accessories": // 1
                    obj = new TJxSolItemAccessories(Category);
                    break;
                case "Armours": // 2
                    obj = new TJxSolItemArmours(Category);
                    break;
                case "Characters": // 3
                    obj = new TJxSolItemCharacters(Category);
                    break;
                case "Classes": // 4
                    obj = new TJxSolItemClasses(Category);
                    break;
                case "Consumables": // 5
                    obj = new TJxSolItemConsumables(Category);
                    break;
                case "Enchantments": // 6
                    obj = new TJxSolItemEnchantments(Category);
                    break;
                case "Enemies": // 7
                    obj = new TJxSolItemEnemies(Category);
                    break;
                case "Global": // 8
                    obj = new TJxSolItemGlobal(Category);
                    break;
                case "ItemGroups": // 9
                    obj = new TJxSolItemGroups(Category);
                    break;
                case "Keys": // 10
                    obj = new TJxSolItemKeys(Category);
                    break;
                case "Missions": // 11
                    obj = new TJxSolItemMissions(Category);
                    break;
                case "Monsters": // 12
                    obj = new TJxSolItemMonsters(Category);
                    break;
                case "MonsterSkills": // 13
                    obj = new TJxSolItemMonsterSkills(Category);
                    break;
                case "Print_Area": // 14
                    obj = new TJxSolItemPrint_Area(Category);
                    break;
                case "Qualities": // 15
                    obj = new TJxSolItemQualities(Category);
                    break;
                case "SkillGroups": // 16
                    obj = new TJxSolItemSkillGroups(Category);
                    break;
                case "Skills": // 17
                    obj = new TJxSolItemSkills(Category);
                    break;
                case "Terrains": // 18
                    obj = new TJxSolItemTerrains(Category);
                    break;
                case "Weapons": // 19
                    obj = new TJxSolItemWeapons(Category);
                    break;
                case "Zones": // 20
                    obj = new TJxSolItemZones(Category);
                    break;
                default:
                    throw new Exception(string.Format("unknown Category1=({0})", Category));
            }
            return obj;
        }
    }
    /// <summary>
    /// 01.Accessories
    /// </summary>
    public class TJxSolItemAccessories : TJxSolItemBase // 1
    {
        public TJxSolItemAccessories(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[9];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[9]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[9]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 9:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 02.Armours
    /// </summary>
    public class TJxSolItemArmours : TJxSolItemBase // 2
    {
        public TJxSolItemArmours(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[14];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[14]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[14]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 4:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 03.Characters
    /// </summary>
    public class TJxSolItemCharacters: TJxSolItemBase // 3
    {
        public TJxSolItemCharacters(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string NameNonIdentified = this.ItemDetailList[13];
            string Description = this.ItemDetailList[16];
            return string.Format("Category={0} ID={1} Name={2} NameNonIdentified={3} Description={4}", Category, ID, Name, NameNonIdentified, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("NameNonIdentified", this.ItemDetailList[13]);
            dict.Add("Description", this.ItemDetailList[16]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "NameNonIdentified", this.ItemDetailList[13]); csvList.Add(data2);
            TJxCsvData data3 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[16]); csvList.Add(data3);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 13:
                case 16:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 04.Classes
    /// </summary>
    public class TJxSolItemClasses : TJxSolItemBase // 4
    {
        public TJxSolItemClasses(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[15];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[15]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[15]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 15:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 05.Consumables
    /// </summary>
    public class TJxSolItemConsumables : TJxSolItemBase // 5
    {
        public TJxSolItemConsumables(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[17];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[17]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[17]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 17:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 06.Enchantments
    /// </summary>
    public class TJxSolItemEnchantments : TJxSolItemBase // 6
    {
        public TJxSolItemEnchantments(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[42];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[42]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[42]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 42:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 07.Enemies
    /// </summary>
    public class TJxSolItemEnemies : TJxSolItemBase // 7
    {
        public TJxSolItemEnemies(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            return string.Format("Category={0} ID={1} Description={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 08.Global
    /// </summary>
    public class TJxSolItemGlobal : TJxSolItemBase // 8
    {
        public TJxSolItemGlobal(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 09.ItemGroups
    /// </summary>
    public class TJxSolItemGroups : TJxSolItemBase // 9
    {
        public TJxSolItemGroups(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[5];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[5]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[5]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 5:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 10.Keys
    /// </summary>
    public class TJxSolItemKeys : TJxSolItemBase // 10
    {
        public TJxSolItemKeys(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 11.Missions
    /// </summary>
    public class TJxSolItemMissions : TJxSolItemBase // 11
    {
        public TJxSolItemMissions(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[8];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[8]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[8]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 8:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 12.Monsters
    /// </summary>
    public class TJxSolItemMonsters : TJxSolItemBase // 12
    {
        public TJxSolItemMonsters(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[5];
            string Description = this.ItemDetailList[33];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[5]);
            dict.Add("Description", this.ItemDetailList[33]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[5]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[33]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 5:
                case 33:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 13.MonsterSkills
    /// </summary>
    public class TJxSolItemMonsterSkills : TJxSolItemBase // 13
    {
        public TJxSolItemMonsterSkills(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[20];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[20]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[20]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 20:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 14.Print_Area
    /// </summary>
    public class TJxSolItemPrint_Area : TJxSolItemBase // 14
    {
        public TJxSolItemPrint_Area(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 15.Qualities
    /// </summary>
    public class TJxSolItemQualities : TJxSolItemBase // 15
    {
        public TJxSolItemQualities(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Metal = this.ItemDetailList[5];
            string Wood = this.ItemDetailList[7];
            string Leather = this.ItemDetailList[9];
            string Cloth = this.ItemDetailList[11];
            string Mineral = this.ItemDetailList[13];
            string Description = this.ItemDetailList[15];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID,Metal ,Wood,Leather,Cloth,Mineral, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Metal", this.ItemDetailList[5]);
            dict.Add("Wood", this.ItemDetailList[7]);
            dict.Add("Leather", this.ItemDetailList[9]);
            dict.Add("Cloth", this.ItemDetailList[11]);
            dict.Add("Mineral", this.ItemDetailList[13]);
            dict.Add("Description", this.ItemDetailList[15]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Metal", this.ItemDetailList[5]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Wood", this.ItemDetailList[7]); csvList.Add(data2);
            TJxCsvData data3 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Leather", this.ItemDetailList[9]); csvList.Add(data3);
            TJxCsvData data4 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Cloth", this.ItemDetailList[11]); csvList.Add(data4);
            TJxCsvData data5 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Mineral", this.ItemDetailList[13]); csvList.Add(data5);
            TJxCsvData data6 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[15]); csvList.Add(data6);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 5:
                case 7:
                case 9:
                case 11:
                case 13:
                case 15:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 16.SkillGroups
    /// </summary>
    public class TJxSolItemSkillGroups : TJxSolItemBase // 16
    {
        public TJxSolItemSkillGroups(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[8];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[8]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[8]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 8:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 17.Skills
    /// </summary>
    public class TJxSolItemSkills : TJxSolItemBase // 17
    {
        public TJxSolItemSkills(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[6];
            string Description = this.ItemDetailList[35];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[6]);
            dict.Add("Description", this.ItemDetailList[35]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[6]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[35]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 6:
                case 35:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 18.Terrains
    /// </summary>
    public class TJxSolItemTerrains : TJxSolItemBase // 18
    {
        public TJxSolItemTerrains(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[11];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[11]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[11]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 11:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 19.Weapons
    /// </summary>
    public class TJxSolItemWeapons : TJxSolItemBase // 19
    {
        public TJxSolItemWeapons(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[25];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[25]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[25]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 25:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 20.Zones
    /// </summary>
    public class TJxSolItemZones : TJxSolItemBase // 20
    {
        public TJxSolItemZones(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[21];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[21]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[21]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 21:
                    return true;
                default:
                    return false;
            }
        }
    }
}
