/*
 * my_resize_rotate.cpp
 *
 *  Created on: 2016/08/11
 *      Author: takemasa
 */

#include <opencv2/opencv.hpp>
#include <iostream>


#include "my_funcs.h"

cv::Mat my_rotate(cv::Mat src)
{
	cv::Mat dst;

		// ソース画像の中点を求める
	cv::Point2f sourceCenter( src.rows / 2.0, src.cols / 2.0 );

		// ソース画像の中点を軸とする回転行列を作る。角度は度数法
	cv::Mat rot_mat = cv::getRotationMatrix2D( sourceCenter, 45, 1.0);

		// アフィン変換を使って画像を回転させる
	cv::warpAffine( src, dst, rot_mat, src.size());

	return dst;
}


