/**
 * @file rotenc.h
 * @author Shinichiro Nakamura
 * @brief ROTENC制御プログラム
 * @details
 * ROTENC制御タスク及びAPI。cfgファイルから読み込んで使う
 */


#ifndef ROTENC_H
#define ROTENC_H

#include "uzume.h"

/*
 * タスク優先順位はGUIや一般タスクより低くても構わない。
 * タスク優先順位とスタックサイズを変更する場合には sys_config.h でマクロ宣言する
 */
#ifndef ROTENC_TASK_PRIORITY
#define ROTENC_TASK_PRIORITY 7
#endif

#ifndef ROTENC_TASK_STACK_SIZE
#define ROTENC_TASK_STACK_SIZE 1024
#endif


#ifndef _MACRO_ONLY

extern void rotenc_task(VP_INT exinf);
fract32 rotenc_get_volume(unsigned int ch);
void rotenc_set_volume(unsigned int ch, fract32 value);


#endif
#endif /* ROTENC_H */

