/**
 * \file fx32_fir.h
 * \date 2013/05/01
 * \author takemasa
 * \brief Basic FIR filter implementation
 *
 */

#ifndef FX32_FIR_H_
#define FX32_FIR_H_

#include <fract.h>

typedef struct
{
	int taps;
	fract32 * coeff;
	fract32 * delayline;
	fract32 * headhead;
}TFIR32;

void fract32_fir_init( TFIR32 *filter, int taps, fract32 * coeff, fract32 * delayline);
void fract32_fir(TFIR32 *filter, fract32 in[], fract32 out[], int count );

#endif /* FX32_FIR_H_ */
