require 'test_helper'

class UsersControllerTest < ActionController::TestCase
  setup do
    @user = users(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:users)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create user" do
    assert_difference('User.count') do
      post :create, user: { authority: @user.authority, birth_d: @user.birth_d, email: @user.email, id: @user.id, name: @user.name, password: @user.password, password_digest: @user.password_digest, pref: @user.pref, realname: @user.realname, register_d: @user.register_d, selfintro: @user.selfintro }
    end

    assert_redirected_to user_path(assigns(:user))
  end

  test "should show user" do
    get :show, id: @user
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @user
    assert_response :success
  end

  test "should update user" do
    put :update, id: @user, user: { authority: @user.authority, birth_d: @user.birth_d, email: @user.email, id: @user.id, name: @user.name, password: @user.password, password_digest: @user.password_digest, pref: @user.pref, realname: @user.realname, register_d: @user.register_d, selfintro: @user.selfintro }
    assert_redirected_to user_path(assigns(:user))
  end

  test "should destroy user" do
    assert_difference('User.count', -1) do
      delete :destroy, id: @user
    end

    assert_redirected_to users_path
  end
end
