class ApplicationController < ActionController::Base
  before_filter :detect_locale
  protect_from_forgery

  private
  def detect_locale
    I18n.locale = request.headers['Accept-Language'].scan(/^[a-z]{2}/).first
  end
end
