#!/bin/bash

rails generate scaffold mountains \
  id:integer \
  uname:string \
  kana:string  \
  name1:string \
  name2:string \
  name3:string \
  elevation:integer \
  number_300meizan \
  district:string \
  latitude:float \
  longitude:float \
  prefs:string \
  map200:string \
  map050:string \
  map025:string \
  fl_yama1000:boolean \
  fl_100meizan:boolean \
  fl_200meizan:boolean \
  fl_300meizan:boolean \
  fl_hana:boolean \
  fl_shinhana:boolean \
  fl_shinhyaku:boolean \
  fl_kanto:boolean \
  fl_kansai:boolean \
  fl_kyuushuu:boolean \
  fl_yamanashi:boolean \
  fl_tohoku:boolean \
  fl_niigata:boolean \
  fl_utsukushima:boolean \
  fl_aizu:boolean \
  fl_hokkaido:boolean \
  fl_shikoku:boolean \
  fl_tochigi:boolean \
  fl_gumma:boolean \

rails generate scaffold records \
  id:integer \
  mountain_id:string \
  user_id:string \
  publish_d:date \
  title:string \
  start_d:date \
  end_d:date \
  body:string \

rails generate scaffold users \
  id:integer \
  name:string \
  realname:string \
  password:string \
  password_digest:string \
  birth_d:date \
  register_d:date \
  authority:string \
  email:string \
  pref:string \
  selfintro:string \

rails generate scaffold blogs \
  id:integer \
  user_id:string \
  mountain_id:integer \
  issue_dt:datetime \
  title:string \
  body:string \

rails generate scaffold blog-comments \
  id:integer \
  blog_id:integer \
  user_id:string \
  fl_publish:boolean \
  issue_dt:datetime  \
  title:string \
  body:string \

rails generate model mountains-blogs \
  mountain:references \
  blog:references \

rails generate model mountains-records \
  mountain:references \
  record:references \

