class User < ActiveRecord::Base
  attr_accessible :authority, :birth_d, :email, :id, :name, :password, :password_digest, :pref, :realname, :register_d, :selfintro
  # ログイン判定処理（bcrypt-ruby版）の場合は、上の行をオフにし、下の行をオンにすること。
  # attr_accessible :name, :password
  # validates :name, presence; true, uniqueness: true

  # ログイン判定処理（bcrypt-ruby版）の場合は、has_secure_password をオンにすること。
  # has_secure_password
  has_many :blogs
  has_many :mountains, :through => :blogs
  has_many :records

  def self.authenticate(username, password)
    where(:name => username,
      :password => Digest::SHA1.hexdigest(password)).first
  end
end
