class ApplicationController < ActionController::Base
  before_filter :detect_locale
  before_filter :check_logined
  protect_from_forgery

  def logout
    reset_session
    redirect_to '/'
  end

  private
  # Ƚ
  def detect_locale
    I18n.locale = request.headers['Accept-Language'].scan(/^[a-z]{2}/).first
  end
  def authorize
    unless User.find_by_id(session[:user_id])
      redirect_to login_url, notice: "Please login"
    end
  end
  # Ƚǧڥ᥽åɼǡ
  def check_logined
    if session[:usr] then
      begin
        @usr = User.find(session[:usr])
      rescue ActiveRecord::RecordNotFound
        reset_session
      end
    end
    unless @usr
      flash[:referer] = request.fullpath
      redirect_to :controller => 'login', :action => 'index'
    end
  end


end
