﻿using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Rank00 {
    public partial class MainForm : Form {
        string path = @"C:\Program Files\Live2ch\log\";

        public MainForm() {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e) {
            if (appendPanel.Visible) {
                button1.Text = "▼";
                groupBox1.Height = 68;
                this.Height -= 115 - 68;
            } else {
                button1.Text = "▲";
                groupBox1.Height = 115;
                this.Height += 115 - 68;
            }
            appendPanel.Visible = !appendPanel.Visible;
        }

        private void Rank(object sender, EventArgs e){
            Rank();
        }

        /// <summary>
        /// ランキングを作成する。
        /// </summary>
        private void Rank() {
            //MessageBox.Show("てすと", this.Text);
            Regex reg = new Regex(@"^h?ttp://([-\w.]+(?:/[-\w]+)*?)/test/read\.cgi/(\w+)/(\d{10})/",
                RegexOptions.ECMAScript);
            Match m = reg.Match(urlTextBox.Text);
            if (m.Success) {
                string msg = 
@"マッチしました。
サーバー：{0}
板：{1}
DAT：{2}";
                MessageBox.Show(string.Format(msg, m.Groups[1], m.Groups[2] , m.Groups[3]), this.Text);

                string server = m.Groups[1].Value;
                string board = m.Groups[2].Value;
                string dat = m.Groups[3].Value;
                string path = Path.Combine(this.path, server.Replace('/', '_') + '\\' + board + '\\' + dat + ".dat");

                if (!File.Exists(path)) {
                    MessageBox.Show("ファイルが見つかりません。\n" + path, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }
                string[] lines = File.ReadAllLines(path, Encoding.GetEncoding("Shift_JIS"));


            }

        }
    }
}
