                        Turbo Pascal for DOS Tutorial
                              Table of Contents
                   Copyright (c) 1996 by Glenn Grotzinger


Part 1: The basics.
        A) Basic discussion of what a program is and some rudimentary
           operations such as assign statements, simple variables,
           computations, and screen writes and reads.

Part 2: IF statements, FOR loops, and format codes.
        A) Concepts of the usage of IF statements, FOR loops, and
           format codes that may be placed with writes.

Part 3: WHILE loops, REPEAT loops, CASE statements, string addressing.
        A) Concepts of the usage of WHILE loops, REPEAT loops, CASE
           statements.
        B) Methods on how to address a string or parts of a string.

Part 4: Procedures and Functions; TYPE and CONST declarations.
        A) Methods of defining procedures and functions in a program.
        B) The usage of TYPE and CONSTant declarations.

Part 5: Reading and Writing to Text Files; writing to the printer
        A) Concepts of reading from text files.
        B) Concepts of writing to text files and to the printer.

Part 6: Arrays and their Usage; ASCII conversion functions
        A) Concepts and usage of arrays.
        B) Usage of the functions chr() and ord().

Part 7: Records and their usage; Mathematics Concepts of the Computer.
        A) Concepts and usage of records.
        B) Concepts of Mathematics.
           1) Mathematics functions offered by TP.
           2) Binary and Hexadecimal notation.

Part 8: DOS file functions and their usage.
        A) A basic summary of Turbo Pascal functions and procedures that
           are equivalent to DOS commands.
        B) Concepts of most of the procedures and functions in the DOS
           or WinDOS units.

Part 9: Applications Development.
        A) Concepts of applications development.  The usage of pseudocode
           to solve a problem.

Part 10: Reading and Writing to Binary Files; Units and Overlays.
        A) Concepts of reading binary files.
        B) Concepts of writing to binary files.
        C) Concepts and usage of units.
        D) Concepts and usage of overlays.

Part 11: Interfacing with a Common Format; or how is different
variables stored by Pascal in memory, and on disk files?
        A) Discussions of storage formats in memory and disk by Turbo
           Pascal.
        B) Interpretation of meanings of data presented on a commonly
           used format.

Part 12: Stacks; Queues
        A) Concepts and usage of stacks and queues.

Part 13: Use of Recursion
        A) Concepts and usage of recursion.

Part 14: The CRT Unit commands not already covered; Reading of extended
keys on the keyboard.
        A) Changing colors on the screen (text mode).
        B) Working with the PC speaker.
        C) Controlling the screen appearance and cursor position.

Part 15: Three different designed array sorts.
        A) Definition and concept of usage of the BubbleSort.
        A) Definition and concept of usage of the QuickSort.
        B) Definition of the ShellSort.

Part 16: Methods of searching arrays for data (binary search).
        A) Concepts of the Serial Search.
        B) Concepts of the Binary Search.

Part 17: Use of Pointers in variables, and procedures; designing a 
set exit procedure (exitproc). (Dynamic Variables)
        A) Concepts of the addressing of pointers in variables.
        B) Concepts of addressing pointers in procedures and functions.
        C) Design of an exit procedure (use of exitproc).

Part 18: Design and use of chained lists, or linked lists; the linked
list sort.
        A) Concepts of SLLLs, DLLLs, SLCLs, DLCLs.
        B) Sorting data using a linked-list.

Part 19: Descriptions of other types of pointer-linked structures;
        A) Concepts of a binary tree.
        B) Usage of a binary tree.

Part 20: Linking assembler into Pascal code; special topics.
        A) Linking OBJ files into Pascal code.
        B) Hooking a hardware interrupt and writing interrupt code.
        C) Calling a specified interrupt procedure.
        D) Including inline statements in pascal code.
        E) Including assembler statements in pascal code.
        F) Conditional compiler directives.

Part 21: BGI graphics; plotting graphics.
        A) Concepts of usage of the Borland Graphics Interface.
        B) Plotting graphics.
        C) Concepts behind drawing of lines, circles, and other
           geometric figures.
