
#include <iostream>

#include "gmock/gmock.h"
#include "mt_typelist.h"
#include "mt_type_identity.h"

namespace mt {

TEST(TypelistTest, creation_using_MakeTypelist1)
{
    typedef IsIdentical<
                        mt::MakeTypelist<int>::Result,
                        mt::Typelist<int, mt::NullType>
                        > MakeTypelist_int_IsIdentical_to_Typelist_int_NullType;

    bool is_identical_type = MakeTypelist_int_IsIdentical_to_Typelist_int_NullType::value;
    EXPECT_EQ(is_identical_type, true);

}

TEST(TypelistTest, creation_using_MakeTypelist2)
{
    typedef IsIdentical<
                        mt::MakeTypelist<int, char>::Result,
                        mt::Typelist<int, mt::Typelist<char, mt::NullType> >
                        > MakeTypelist_int_char_IsIdentical_to_Typelist_int_char_NullType;

    bool is_identical_type = MakeTypelist_int_char_IsIdentical_to_Typelist_int_char_NullType::value;
    EXPECT_EQ(is_identical_type, true);
}

} // namespace mt

