
#include "gtest/gtest.h"
#include "mt_typelist.h"
#include "mt_type_identity.h"

namespace mt {

class TypelistAppendTest : public ::testing::Test
{
protected:
    virtual void SetUp()
    {}

    virtual void TearDown()
    {}
};

TEST_F(TypelistAppendTest, test)
{
    typedef MakeTypelist<char, short, long, int>::Result Char_Short_Long_Int_types;

    typedef MakeTypelist<float, double>::Result Float_Double_types;

    bool is_identical_type = IsIdentical<Append<Char_Short_Long_Int_types,
                                                Float_Double_types>::Result,
                                         MakeTypelist<char, short, long, int, float, double>::Result>::value;

    EXPECT_EQ(is_identical_type, true);
}


} // namespace mt
