
#include <cstring>
#include <string>

#include "gtest/gtest.h"
#include "mt_shim_clear_memory.h"
#include "mt_container_foreach.h"

TEST(MtShimClearMemoryTest, builtin_type_array)
{
    char str_array[10];

    strcpy(str_array, "hello");

    mt::clearMemory(str_array);

    CONTAINER_FOREACH_CONST(const char& item, str_array) {
        EXPECT_EQ(item, 0x00);
    }

    int int_array[10];

    int val = 0;
    CONTAINER_FOREACH(int& item, int_array) {
        item = val;
        ++val;
    }

    mt::clearMemory(int_array);

    CONTAINER_FOREACH_CONST(const int& item, int_array) {
        EXPECT_EQ(item, 0);
    }
}

TEST(MtShimClearMemoryTest, std_string)
{
    std::string str("hello world");

    std::string empty;

    mt::clearMemory(str);

    EXPECT_EQ(str.length(), 0);
    EXPECT_STREQ(str.c_str(), empty.c_str());
}

TEST(MtShimClearMemoryTest, std_container)
{
    std::vector<int> vec;

    vec.resize(10);

    int val = 0;
    CONTAINER_FOREACH(int& item, vec) {
        item = val;
        ++val;
    }

    mt::clearMemory(vec);

    CONTAINER_FOREACH_CONST(const int& item, vec) {
        EXPECT_EQ(item, 0);
    }
}


