
#ifndef INC_MT_TYPELIST_ALGO_UTILITY_H_
#define INC_MT_TYPELIST_ALGO_UTILITY_H_

#include "mt_typelist.h"
#include "mt_mpl.h"
#include "mt_sfinae.h"
#include "mt_type_identity.h"

namespace mt {

template <typename T>
struct HasCtorArgsType
{
    template <typename X>
    static YesTypeWith1TemplateParam<X, typename X::CtorArgsType> test(X*);

    template <typename X>
    static NoType test(...);

    static const bool value = sizeof(test<T>(0)) != sizeof(NoType);
};

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
T getObject(Arg1&, Arg2&, Arg3&, Arg4&, typename EnableIf<!HasCtorArgsType<T>::value>::Result* = 0)
{
    return T();
}

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
T getObject(Arg1& arg1, Arg2&, Arg3&, Arg4&, typename EnableIf<IsIdentical<typename T::CtorArgsType, StaticValue<int, 1> >::value>::Result* = 0)
{
    return T(arg1);
}

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
T getObject(Arg1& arg1, Arg2& arg2, Arg3&, Arg4&, typename EnableIf<IsIdentical<typename T::CtorArgsType, StaticValue<int, 2> >::value>::Result* = 0)
{
    return T(arg1, arg2);
}

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
T getObject(Arg1& arg1, Arg2& arg2, Arg3& arg3, Arg4&, typename EnableIf<IsIdentical<typename T::CtorArgsType, StaticValue<int, 3> >::value>::Result* = 0)
{
    return T(arg1, arg2, arg3);
}

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
T getObject(Arg1& arg1, Arg2& arg2, Arg3& arg3, Arg4& arg4, typename EnableIf<IsIdentical<typename T::CtorArgsType, StaticValue<int, 4> >::value>::Result* = 0)
{
    return T(arg1, arg2, arg3, arg4);
}

inline NullType& getNullType()
{
    static NullType nulltype_object;
    return nulltype_object;
}

} // namespace mt

#endif  // INC_MT_TYPELIST_ALGO_UTILITY_H_

