
#ifndef INC_MT_TYPE_CONVERTIBILITY_H_
#define INC_MT_TYPE_CONVERTIBILITY_H_

#include "mt_sfinae.h"

namespace mt {

template <typename To, typename From>
struct IsConvertible
{
private:
    static From& makeFrom();

    template <typename X>
    static YesType test(X&);

    template <typename X>
    static NoType test(...);

public:
    static const bool value = sizeof(test<To>(makeFrom())) != sizeof(NoType);
};

} // namespace mt
#endif // INC_MT_TYPE_CONVERTIBILITY_H_
