
#ifndef INC_MT_AUTO_PTR_H_
#define INC_MT_AUTO_PTR_H_

#include <assert.h>
#include "mt_static_assert.h"

namespace mt {

template <typename T>
struct AutoPtrRef
{
    explicit AutoPtrRef(T* ptr)
        : raw_ptr_(ptr)
    {}

    T* raw_ptr_;
};

template <typename T>
class AutoPtr
{
public:
    AutoPtr()
        : raw_ptr_(0)
    {}

    AutoPtr(T* ptr)
        : raw_ptr_(ptr)
    {}

    AutoPtr(AutoPtr<T>& rhs)
        : raw_ptr_(rhs.release())
    {}

    AutoPtr(AutoPtrRef<T> ref)
        : raw_ptr_(ref.raw_ptr_)
    {}

    AutoPtr<T>& operator=(AutoPtrRef<T> ref)
    {
        this->reset();
        this->raw_ptr_ = ref.raw_ptr_;
        return *this;
    }

    operator AutoPtrRef<T> ()
    {
        return AutoPtrRef<T>(release());
    }

    ~AutoPtr()
    {
        reset();
    }

    T* release()
    {
        T* ptr_to_return = raw_ptr_;
        raw_ptr_ = 0;
        return ptr_to_return;
    }

    void set(T* new_ptr)
    {
        assert(raw_ptr_ == 0);
        raw_ptr_ = new_ptr;
        return;
    }

    T* get()
    {
        return raw_ptr_;
    }

    const T* get() const
    {
        return raw_ptr_;
    }

    void reset()
    {
        STATIC_ASSERT(sizeof(*raw_ptr_) > 0);
        delete raw_ptr_;
        raw_ptr_ = 0;
    }

    AutoPtr& operator=(AutoPtr& rhs)
    {
        if (this != &rhs) {
            this->reset();
            this->set(rhs.get());
            rhs.release();
        }
        return *this;
    }

    T* operator->()
    {
        return raw_ptr_;
    }

    T& operator*()
    {
        return *raw_ptr_;
    }

    const T& operator*() const
    {
        return *raw_ptr_;
    }

    const T* operator->() const
    {
        return raw_ptr_;
    }

private:

    T* raw_ptr_;
};

} // namespace mt

#endif // INC_MT_AUTO_PTR_H

