#ifndef INC_CM_VECTOR_SOCKET_H_
#define INC_CM_VECTOR_SOCKET_H_

#include <unistd.h>
#include <sys/uio.h>
#include <vector>
#include <iostream>

#include "mt_member_detector.h"
#include "mt_mpl.h"
#include "cm_io_vector.h"

namespace cm {

class VectorSocket
{
public:
    VectorSocket(int fd);

    template <typename SocketType>
    VectorSocket(SocketType& socket, typename mt::EnableIf<mt::HasReleaseMethod<SocketType>::value>::Result* = 0)
        : fd_(socket.release())
    {}

    static const int MAX_IOVEC_COUNT = 64;

    bool writev(size_t& bytes_written, const IOVectorBase& vector, size_t skip_bytes = 0u);
    // bool readv(size_t& bytes_read, IOVector<T>& vector);

    int release();

private:
    int fd_;
};

} // namespace cm

#endif // INC_CM_VECTOR_SOCKET_H_
