
#ifndef INC_CM_SOCKET_H_
#define INC_CM_SOCKET_H_

#include "cm_socket_if.h"
#include "mt_mpl.h"
#include "mt_member_detector.h"

namespace cm {

class Socket : public SocketIf
{
public:
    Socket();
    Socket(int fd);

    template <typename SocketType>
    Socket(SocketType& socket, typename mt::EnableIf<mt::HasReleaseMethod<SocketType>::value>::Result* = 0)
        : fd_(socket.release())
    {}

    virtual ~Socket();

    virtual bool read(size_t& bytes_read, void* buf, size_t size_to_read);
    virtual bool write(size_t& bytes_written, const void* buf, size_t size_to_write);

    virtual int getFD() const;

    virtual int release();
private:
    virtual SocketIf* doClone(int fd) const;

    int fd_;
};

} // namespace cm

#endif // INC_CM_SOCKET_H_
