
#ifndef INC_CM_EVENT_KQUEUE_H_
#define INC_CM_EVENT_KQUEUE_H_

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <errno.h>
#include <map>
#include <iostream>

#include "mt_type_erasure_handler.h"
#include "mt_type_convertibility.h"
#include "mt_range.h"

namespace cm {

class Event
{
private:
    static const unsigned int MAX_NUMBER_OF_HANDLERS = 64u;

public:
    static Event& tsdInstance();

    ~Event();

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerRead(T& obj, bool (T::*Handler)(EventBaseType&), EventType& etype,
                        typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int read_fd = getFD(etype);

        read_map_[read_fd] = new mt::HandlerHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);
        struct kevent kev;
        EV_SET(&kev, read_fd, EVFILT_READ, EV_ADD, 0, 0, NULL);
        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            assert(false);
        }
    }

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerRead(T& obj, bool (T::*Handler)(EventBaseType&) const, EventType& etype,
                        typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int read_fd = getFD(etype);

        read_map_[read_fd] = new mt::HandlerConstHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);
        struct kevent kev;
        EV_SET(&kev, read_fd, EVFILT_READ, EV_ADD, 0, 0, NULL);
        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            assert(false);
        }
    }

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerWrite(T& obj, bool (T::*Handler)(EventBaseType&), EventType& etype,
                         typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int write_fd = getFD(etype);

        write_map_[write_fd] = new mt::HandlerHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);
        struct kevent kev;
        EV_SET(&kev, write_fd, EVFILT_WRITE, EV_ADD, 0, 0, NULL);
        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            std::cout << "kevent error [" << strerror(errno) << "]" << std::endl;
            assert(false);
        }
    }

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerWrite(T& obj, bool (T::*Handler)(EventBaseType&) const, EventType& etype,
                         typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int write_fd = getFD(etype);

        write_map_[write_fd] = new mt::HandlerConstHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);
        struct kevent kev;
        EV_SET(&kev, write_fd, EVFILT_WRITE, EV_ADD, 0, 0, NULL);
        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            assert(false);
        }
    }

    template <typename EventType>
    void delHandlerRead(EventType& etype)
    {
        int read_fd = getFD(etype);

        struct kevent kev;
        EV_SET(&kev, read_fd, EVFILT_READ, EV_DELETE, 0, 0, NULL);

        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            assert(false);
        }

        HandlerMap::iterator it = read_map_.find(read_fd);
        assert(it != mt::end(read_map_));

        delete (*it).second;
        read_map_.erase(it);
    }

    template <typename EventType>
    void delHandlerWrite(EventType& etype)
    {
        int write_fd = getFD(etype);
    
        struct kevent kev;
        EV_SET(&kev, write_fd, EVFILT_WRITE, EV_DELETE, 0, 0, NULL);

        if (0 != kevent(kqueue_, &kev, 1, NULL, 0, NULL)) {
            assert(false);
        }

        HandlerMap::iterator it = write_map_.find(write_fd);
        assert(it != mt::end(write_map_));

        delete (*it).second;
        write_map_.erase(it);
    }

    void pend();

private:
    Event();

    // Non-copyable
    Event(const Event& rhs);
    Event& operator=(const Event& rhs);

    int kqueue_;

    typedef std::map<int, mt::HandlerBase<bool> *> HandlerMap;
    std::map< int, mt::HandlerBase<bool>* > read_map_;
    std::map< int, mt::HandlerBase<bool>* > write_map_;
};

} // namespace cm

#endif // INC_CM_EVENT_KQUEUE_H_

