
#ifndef INC_CM_CONDITION_H_
#define INC_CM_CONDITION_H_

#include "cm_mutex.h"

namespace cm {

class Condition
{
public:
    Condition();
    ~Condition();

    void wait(const Mutex& mutex);
    void broadcast();

private:
    // Non-copyable
    Condition(const Condition& rhs);
    Condition& operator=(const Condition& rhs);

    pthread_cond_t cond_;
};

} // namespace cm

#endif // INC_CM_CONDITION_H_

