
#include "types.h"
#include "mt_auto_ptr.h"
#include "cm_event.h"
#include "cm_socket_if.h"
#include "http/http_socket_manager.h"

namespace http {

HttpSocketManager::HttpSocketManager(const char_t* address, ushort port_number)
    : port_(port_number),
      server_socket_(cm::SOCKET_TYPE_INET_STREAM, address, port_),
      event_(cm::Event::tsdInstance())
{
    event_.addHandlerRead(*this, &HttpSocketManager::handleAccept, server_socket_);
}

HttpSocketManager::~HttpSocketManager()
{
    event_.delHandlerRead(server_socket_);
}

bool HttpSocketManager::handleAccept(cm::SocketServer& server_sock)
{
    mt::AutoPtr<cm::SocketIf> socket = server_sock.accept();

    return true;
}

} // namespace http
