
#include <sys/socket.h>
#include <utility>
#include <fcntl.h>
#include <errno.h>
#include <iostream>
#include <string.h>

#include "cm_socket.h"
#include "cm_socket_client.h"
#include "cm_socket_setter.h"
#include "mt_unuse.h"
#include "mt_typelist_algo_find_if.h"

namespace cm {

SocketClient::SocketClient(SocketType type, bool is_nonblock)
    : is_nonblock_(is_nonblock), socket_type_(type)
{
}

SocketClient::~SocketClient()
{}

SocketIf* SocketClient::doConnect(const char* server_name, unsigned short port)
{
    std::pair<int, int> domain_proto_pair;
    bool ret = mt::FindIf<SocketSetterTypes>()(domain_proto_pair, socket_type_);
    assert(ret);

    int fd = socket(domain_proto_pair.first, domain_proto_pair.second, 0);
    assert(fd >= 0);

    std::pair<SocketAddress, socklen_t> address_length_pair;
    ret = mt::FindIf<SocketAddressSetterTypes>(server_name, port)(address_length_pair, domain_proto_pair.first);
    assert(ret == true);

    if (is_nonblock_) {
        int current_flag = fcntl(fd, F_GETFL, &current_flag);
        assert(fcntl(fd, F_SETFL, (current_flag | O_NONBLOCK)) == 0);
    }

    int retval = ::connect(fd, reinterpret_cast<struct sockaddr*>(&address_length_pair.first),
                         address_length_pair.second);

    if (retval < 0) {
        if (errno == EWOULDBLOCK || errno == EAGAIN ||
            errno == EINPROGRESS || errno == EALREADY) {
            std::cout << __func__ << "(0) " << strerror(errno) << std::endl;
            return new Socket(fd);
        }
        std::cout << __func__ << "(1) " << strerror(errno) << std::endl;
        return 0;
    }
        
    return new Socket(fd);
}

} // namespace cm
