
#include <unistd.h>
#include <errno.h>

#include "cm_socket.h"

namespace cm {

Socket::Socket()
    : fd_(-1)
{}

Socket::Socket(int fd)
    : fd_(fd)
{}

Socket::~Socket()
{
    if (fd_ >= 0) {
        close(fd_);
        fd_ = -1;
    }
}

bool Socket::read(size_t& bytes_read, void* buf, size_t size_to_read)
{
    assert(fd_ >= 0);

    ssize_t ret = ::read(fd_, buf, size_to_read);

    if (ret < 0) {
        if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
            return this->read(bytes_read, buf, size_to_read);
        }
        else if (errno == ECONNRESET) {
            return false;
        }
        assert(false);
        return false;
    }
    else if (ret == 0) {
        return false;
    }
    bytes_read = static_cast<size_t>(ret);
    return true;
}

bool Socket::write(size_t& bytes_written, const void* buf, size_t size_to_write)
{
    assert(fd_ >= 0);

    ssize_t ret = ::write(fd_, buf, size_to_write);

    if (ret < 0) {
        if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
            return this->write(bytes_written, buf, size_to_write);
        }
        else if (errno == EPIPE) {
            return false;
        }
        assert(false);
        return false;
    }

    bytes_written = static_cast<size_t>(ret);
    return true;
}

int Socket::getFD() const
{
    return fd_;
}

int Socket::release()
{
    int fd_to_return =  fd_;
    fd_ = -1;
    return fd_to_return;
}

SocketIf* Socket::doClone(int fd) const
{
    return new Socket(fd);
}

} // namespace cm
