
#include <pthread.h>
#include <cassert>

#include "cm_mutex.h"

namespace cm {

Mutex::Mutex(bool is_shared_among_processes)
    : mutex_(), mattr_()
{
    pthread_mutexattr_init(&mattr_);
    pthread_mutexattr_settype(&mattr_, PTHREAD_MUTEX_RECURSIVE);
    int ret = pthread_mutex_init(&mutex_, &mattr_);
    assert(ret == 0);
    // TODO: Consider to support the case that the Mutex is used among
    // different processes
    (void) is_shared_among_processes;
}

Mutex::~Mutex()
{
    int ret = pthread_mutex_destroy(&mutex_);
    assert(ret == 0);
}

void Mutex::lock() const
{
    int ret = pthread_mutex_lock(&mutex_);
    assert(ret == 0);
}

void Mutex::unlock() const
{
    int ret = pthread_mutex_unlock(&mutex_);
    assert(ret == 0);
}

Mutex::Lock::Lock(Mutex& mutex)
    : mutex_(mutex)
{
    mutex_.lock();
}

Mutex::Lock::~Lock()
{
    mutex_.unlock();
}

} // namespace cm
