
#include <unistd.h>

#include "cm_thread_specific_data.h"
#include "cm_event_epoll.h"

namespace cm {

Event& Event::tsdInstance()
{
    if (ThreadSpecificData<Event>::isEmpty()) {
        Event* event = new Event;
        ThreadSpecificData<Event>::set(event);
    }
    return ThreadSpecificData<Event>::get();
}

Event::Event()
    : epfd_(-1), epevent(), read_map_(), write_map_()
{
    epfd_ = epoll_create(MAX_NUMBER_OF_HANDLERS);     // TODO: Refine the max number to do epoll.
    if (epfd_ < 0) {
        assert(false);
    }
}

Event::~Event()
{
    close(epfd_);
}

void Event::pend()
{
    int nfds =  epoll_wait(epfd_, epevent, MAX_NUMBER_OF_HANDLERS, -1);

    if (nfds < 0) {
        assert(false);
    }

    for (int count = 0; count != nfds; ++count) {
        int fd = epevent[count].data.fd;

        if (read_map_.find(fd) != mt::end(read_map_)) {
            if (!read_map_[epevent[count].data.fd]->handleIt()) {
                return;
            }
        }
        if (write_map_.find(fd) != mt::end(write_map_)) {
            if (!write_map_[epevent[count].data.fd]->handleIt()) {
                return;
            }
        }
    }
}

} // namespace cm
