
#include <string>

#include "gtest/gtest.h"

#include "mt_typelist.h"
#include "mt_tuple.h"

TEST(TupleTest, simple_test)
{
    typedef mt::MakeTypelist<int, std::string, long long>::Result Types;

    mt::Tuple<Types> tuple;

    EXPECT_EQ(tuple.get<0>(), 0);
    EXPECT_EQ(tuple.get<int>(), 0);
    EXPECT_EQ(tuple.get<1>().size(), 0u);
    EXPECT_EQ(tuple.get<std::string>().size(), 0u);
    EXPECT_EQ(tuple.get<2>(), 0);
    EXPECT_EQ(tuple.get<long long>(), 0);

    tuple.get<0>() = 10;

    EXPECT_EQ(tuple.get<0>(), 10);
    EXPECT_EQ(tuple.get<int>(), 10);

    tuple.set<0>(10);

}


