
#include <vector>
#include <string>
#include "gtest/gtest.h"
#include "mt_container_foreach.h"
#include "mt_array_length.h"

TEST(ContainerForeachTest, std_vector_container_test)
{
    std::vector<std::string> vec;

    vec.push_back("hello");
    vec.push_back("world");
    vec.push_back("good bye");
    vec.push_back("cruel world");

    unsigned int counter = 0;
    CONTAINER_FOREACH(std::string& item, vec) {
        std::cout << item << std::endl;

        EXPECT_EQ(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        ++counter;
    }
    EXPECT_EQ(counter, vec.size());

    counter = 0;
    CONTAINER_FOREACH(std::string item, vec) {
        EXPECT_NE(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        ++counter;
    }
    EXPECT_EQ(counter, vec.size());

    counter = 0;
    CONTAINER_FOREACH(std::string& item, vec) {
        std::cout << item << std::endl;

        EXPECT_EQ(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        if (counter == 1u) {
            break;
        }
        ++counter;
    }
    EXPECT_EQ(counter, 1u);
    
}

TEST(ContainerForeachConstTest, std_vector_container_test)
{
    std::vector<std::string> vec;

    vec.push_back("hello");
    vec.push_back("world");
    vec.push_back("good bye");
    vec.push_back("cruel world");

    unsigned int counter = 0;

#if 0 // The following code should not be compiled
    CONTAINER_FOREACH_CONST(std::string& item, vec) {
        std::cout << item << std::endl;

        EXPECT_EQ(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        ++counter;
    }
#endif

    CONTAINER_FOREACH_CONST(const std::string& item, vec) {
        std::cout << item << std::endl;

        EXPECT_EQ(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        ++counter;
    }
    EXPECT_EQ(counter, vec.size());

    counter = 0;
    CONTAINER_FOREACH_CONST(std::string item, vec) {
        EXPECT_NE(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        ++counter;
    }
    EXPECT_EQ(counter, vec.size());

    counter = 0;
    CONTAINER_FOREACH(const std::string& item, vec) {
        std::cout << item << std::endl;

        EXPECT_EQ(&item, &vec[counter]);
        EXPECT_STREQ(item.c_str(), vec[counter].c_str());
        if (counter == 1u) {
            break;
        }
        ++counter;
    }
    EXPECT_EQ(counter, 1u);

    const std::string greet("hello world");
    counter = 0;
    CONTAINER_FOREACH_CONST(char ch, std::string("hello world")) {
        std::cout << ch << std::endl;

        EXPECT_EQ(ch, greet[counter]);
        ++counter;
    }
    
}

TEST(ContainerForeachConstTest, fixed_array_test)
{
    std::string fixed_array[10];

    const char* string_array[] = {
        "hello", "world", "3", "4", "5", "6",
        "good", "bye", "cruel", "world"
    };

    unsigned int count = 0;
    CONTAINER_FOREACH(std::string& item, fixed_array) {
        item = string_array[count];
        ++count;
    }
    EXPECT_EQ(ARRAY_LENGTH(fixed_array), count);

    count = 0;
    CONTAINER_FOREACH_CONST(const std::string& item, fixed_array) {
        EXPECT_STREQ(item.c_str(), string_array[count]);
        ++count;
    }
    EXPECT_EQ(ARRAY_LENGTH(fixed_array), count);
}

