
#ifndef INC_MT_TYPELIST_ALGO_FOREACH_H_
#define INC_MT_TYPELIST_ALGO_FOREACH_H_

#include "mt_typelist.h"
#include "mt_typelist_algo_utility.h"

namespace mt {

template <typename TL, typename Arg1 = NullType, typename Arg2 = NullType,
                       typename Arg3 = NullType, typename Arg4 = NullType>
struct ForEach_t;

template <typename T, typename U,
          typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct ForEach_t< Typelist<T, U>, Arg1, Arg2, Arg3, Arg4 >
{
    ForEach_t() : arg1_(getNullType()), arg2_(getNullType()), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1) : arg1_(arg1), arg2_(getNullType()), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2) : arg1_(arg1), arg2_(arg2), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2, Arg3& arg3) : arg1_(arg1), arg2_(arg2), arg3_(arg3), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2, Arg3& arg3, Arg4& arg4) : arg1_(arg1), arg2_(arg2), arg3_(arg3), arg4_(arg4)
    {}

    template <typename V>
    void operator()(V& obj)
    {
        T t(getObject<T>(arg1_, arg2_, arg3_, arg4_));
        t.operator()(obj);

        ForEach_t<U, Arg1, Arg2, Arg3, Arg4>(arg1_, arg2_, arg3_, arg4_)(obj);
        return;
    }

    Arg1& arg1_;
    Arg2& arg2_;
    Arg3& arg3_;
    Arg4& arg4_;
};

template <typename T,
          typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct ForEach_t< Typelist<T, NullType>, Arg1, Arg2, Arg3, Arg4 >
{
    ForEach_t() : arg1_(getNullType()), arg2_(getNullType()), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1) : arg1_(arg1), arg2_(getNullType()), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2) : arg1_(arg1), arg2_(arg2), arg3_(getNullType()), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2, Arg3& arg3) : arg1_(arg1), arg2_(arg2), arg3_(arg3), arg4_(getNullType())
    {}
    ForEach_t(Arg1& arg1, Arg2& arg2, Arg3& arg3, Arg4& arg4) : arg1_(arg1), arg2_(arg2), arg3_(arg3), arg4_(arg4)
    {}

    template <typename V>
    void operator()(V& obj)
    {
        T t(getObject<T>(arg1_, arg2_, arg3_, arg4_));
        t.operator()(obj);
    }

    Arg1& arg1_;
    Arg2& arg2_;
    Arg3& arg3_;
    Arg4& arg4_;
};

template <typename TL>
inline ForEach_t<TL> ForEach()
{
    return ForEach_t<TL>();
}

template <typename TL, typename Arg1>
inline ForEach_t<TL, Arg1> ForEach(Arg1& arg1)
{
    return ForEach_t<TL, Arg1>(arg1);
}

template <typename TL, typename Arg1, typename Arg2>
inline ForEach_t<TL, Arg1, Arg2> ForEach(Arg1& arg1, Arg2& arg2)
{
    return ForEach_t<TL, Arg1, Arg2>(arg1, arg2);
}

template <typename TL, typename Arg1, typename Arg2, typename Arg3>
inline ForEach_t<TL, Arg1, Arg2, Arg3> ForEach(Arg1& arg1, Arg2& arg2, Arg3& arg3)
{
    return ForEach_t<TL, Arg1, Arg2, Arg3>(arg1, arg2, arg3);
}

template <typename TL, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
inline ForEach_t<TL, Arg1, Arg2, Arg3, Arg4> ForEach(Arg1& arg1, Arg2& arg2, Arg3& arg3, Arg4& arg4)
{
    return ForEach_t<TL, Arg1, Arg2, Arg3, Arg4>(arg1, arg2, arg3, arg4);
}

} // namespace mt

#endif  // INC_MT_TYPELIST_ALGO_FOREACH_H_

