
#ifndef INC_MT_MEMBER_DETECTOR_H_
#define INC_MT_MEMBER_DETECTOR_H_

#include "mt_sfinae.h"

namespace mt {

// Meta function to detect whether parameterized type T has void operator() member function.
template <typename T>
struct HasFunctorOperator
{
    template <typename X>
    static mt::YesTypeWithNonConstMemberMethodNoArg<X, void, &X::operator()> test(X*);

    template <typename X>
    static mt::NoType test(...);

    static const bool value = sizeof(test<T>(0)) != sizeof(mt::NoType);
};

// Meta function to detect whether parameterized type T has int relase() member function
template <typename T>
struct HasReleaseMethod
{
    template <typename X>
    static mt::YesTypeWithNonConstMemberMethodNoArg<X, int, &X::release> test(T*);

    template <typename X>
    static mt::NoType test(...);

    static const bool value = sizeof(test<T>(0)) != sizeof(mt::NoType);
};

} // namespace mt

#endif // INC_MT_MEMBER_DETECTOR_H_
