
#if __linux__
#include <sys/prctl.h>
#define SETNAME(tid, name)   prctl(PR_SET_NAME, name, 0lu, 0lu, 0lu)
#elif __FreeBSD__
#include <pthread.h>
#define SETNAME(tid, name)   pthread_set_name_np(tid, name)
#elif (__MACH__ && __APPLE__)
#include <pthread.h>
#define SETNAME(tid, name)   pthread_setname_np(name)
#else
#error "portable symbol was not found."
#endif


