
#ifndef INC_CM_SOCKET_MOCK_H_
#define INC_CM_SOCKET_MOCK_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <deque>
#include <string>

#include "gmock/gmock.h"
#include "cm_socket_if.h"
#include "mt_range.h"

namespace cm {

class SocketMock : public SocketIf
{
public:
    SocketMock(int /* no use */ = 0) : pairfds_()
    {
        /* Although I would like to use SOCK_SEQPACKET here, it seems that
           Mac OS X will not properly handle its combination (socketpair +
           SOCK_SEQPACKET). So we are supposed to use SOCK_DGRAM instead.
        */
        if (0 != socketpair(AF_UNIX, SOCK_DGRAM, 0, pairfds_)) {
            assert(false);
        }
    }

    virtual ~SocketMock()
    {
        close(pairfds_[0]);
        close(pairfds_[1]);
    }

    void invokeRead(void* buf, size_t size_to_put)
    {
        ssize_t ret_value = ::write(pairfds_[1], buf, size_to_put);
        assert(size_to_put == static_cast<size_t>(ret_value));
    }

    virtual int getFD() const
    {
        return pairfds_[0];
    }

    bool read(size_t& bytes_read, void* buf, size_t size_to_read)
    {
        ssize_t ret_value = ::read(pairfds_[0], buf, size_to_read);
        if (ret_value > 0) {
            bytes_read = static_cast<size_t>(ret_value);
            return true;
        }

        if (ret_value == 0) {
            return false;
        }

        std::cout << strerror(errno) << std::endl;
        if (errno == EAGAIN || errno == EINTR) {
            return read(bytes_read, buf, size_to_read);
        }
        return false;
    }

    MOCK_METHOD0(release, int());

    MOCK_METHOD3(write, bool(size_t& bytes_written, const void* buf, size_t size_to_write));
    MOCK_CONST_METHOD1(doClone, SocketIf*(int fd));

private:

    int pairfds_[2];
};

} // namespace cm

#endif // INC_CM_SOCKET_MOCK_H_

