

#ifndef INC_CM_SOCKET_CLIENT_H_
#define INC_CM_SOCKET_CLIENT_H_

#include "cm_socket_type.h"
#include "mt_auto_ptr.h"

namespace cm {

class SocketIf;

class SocketClient
{
public:
    SocketClient(SocketType type, bool is_nonblock = false);

    virtual ~SocketClient();

    bool isReady() const; // TODO: implement this member function in future

    inline mt::AutoPtr<SocketIf> connect(const char* server_name, unsigned short port = 0)
    {
        return mt::AutoPtr<SocketIf>(doConnect(server_name, port));
    }

    inline int getFD() const
    {
        return fd_;
    }

private:
    // Non-copyable
    SocketClient(const SocketClient& rhs);
    SocketClient& operator=(const SocketClient& rhs);

    virtual SocketIf* doConnect(const char* server_name, unsigned short port);

    int fd_;
    bool is_nonblock_;
    SocketType socket_type_;
};

} // namespace cm

#endif // INC_CM_SOCKET_CLIENT_H_
